/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import net.ftb.log.Logger;
import net.ftb.util.CryptoUtils;
import net.ftb.util.OSUtils;

public class User
implements Serializable {
    private static final int serialVersionUID = 1;
    private int _serial = 1;
    private boolean saveMojangData = true;
    private String _username = "";
    private String _name = "";
    private String _encryptedPassword = "";
    private String _encryptedStore = "";
    private String _uuid = "";
    private transient String _password = "";
    private transient String _decryptedStore = "";

    public User(String username, String password, String name) {
        this.setUsername(username);
        this.setPassword(password);
        this.setName(name);
    }

    @Deprecated
    public User(String input) {
        String[] tokens = input.split(":");
        this.setName(tokens[0]);
        this.setUsername(tokens[1]);
        if (tokens.length == 3) {
            this.setPassword(tokens[2]);
        } else if (tokens.length == 4) {
            this.setPassword(tokens[2]);
            this.setStore(tokens[3]);
        }
    }

    public String getUsername() {
        return this._username;
    }

    public void setUsername(String username) {
        this._username = username;
    }

    public String getPassword() {
        return this._password;
    }

    public String getDecryptedDatastore() {
        return this._decryptedStore;
    }

    public void setStore(String store) {
        this._decryptedStore = store;
        this._encryptedStore = this._decryptedStore == null || this._decryptedStore.isEmpty() ? "" : CryptoUtils.encrypt(this._decryptedStore, OSUtils.getMacAddress());
    }

    public void setPassword(String password) {
        this._password = password;
        this._encryptedPassword = this._password == null || this._password.isEmpty() ? "" : CryptoUtils.encrypt(this._password, OSUtils.getMacAddress());
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        switch (this._serial) {
            case 0: {
                if (!this._encryptedPassword.isEmpty()) {
                    Logger.logInfo("Password is being converted to a newer format, ignore following decryption error");
                    Logger.logInfo("Converted password will be saved to disk after successful login");
                    String password = CryptoUtils.decrypt(this._encryptedPassword, OSUtils.getMacAddress());
                    this._encryptedPassword = CryptoUtils.encrypt(password, OSUtils.getMacAddress());
                }
                this._serial = 1;
                break;
            }
        }
        this._password = !this._encryptedPassword.isEmpty() ? CryptoUtils.decrypt(this._encryptedPassword, OSUtils.getMacAddress()) : "";
        this._decryptedStore = this._encryptedStore != null && !this._encryptedStore.isEmpty() ? CryptoUtils.decrypt(this._encryptedStore, OSUtils.getMacAddress()) : null;
    }

    private void writeObject(ObjectOutputStream s) {
        Logger.logDebug("starting...");
        if (!this.saveMojangData) {
            Logger.logDebug("Clearing mojangData");
            this._encryptedStore = "";
        }
        try {
            s.defaultWriteObject();
        }
        catch (IOException e) {
            Logger.logError("logindata save failed", e);
        }
    }

    public void setUUID(String uuid) {
        this._uuid = uuid;
    }

    public String getUUID() {
        return this._uuid;
    }

    public void setSaveMojangData(boolean b) {
        this.saveMojangData = b;
    }

    public boolean getSaveMojangData() {
        return this.saveMojangData;
    }
}

